<?php
session_start();

// Vérifier si les informations de réservation sont définies
if (!isset($_SESSION['dateA'], $_SESSION['dateD'], $_SESSION['np'])) {
    header("Location: error.php"); // Rediriger vers une page d'erreur si les informations ne sont pas disponibles
    exit();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Félicitations - Château de Namur</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
            color: #444;
        }
        header {
            background-color: #4caf50;
            color: white;
            text-align: center;
            padding: 20px;
        }
        header h1 {
            margin: 0;
            font-size: 2em;
        }
        main {
            max-width: 800px;
            margin: 20px auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 20px;
        }
        h2 {
            color: #4caf50;
            margin-bottom: 10px;
        }
        h3 {
            color: #333;
            margin-top: 20px;
        }
        section {
            margin-bottom: 20px;
        }
        .details p {
            margin: 5px 0;
        }
        .details strong {
            color: #4caf50;
        }
        a {
            color: #4caf50;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        footer {
            text-align: center;
            margin-top: 20px;
            padding: 10px 0;
            background: #f1f1f1;
            font-size: 0.9em;
        }
        .btn {
            display: inline-block;
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #4caf50;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }
        .btn:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <header>
        <h1>Félicitations ! 🎉</h1>
    </header>
    
    <main>
        <section>
            <h2>Votre réservation est confirmée !</h2>
            <p>Merci d'avoir choisi le Château de Namur. Nous avons hâte de vous accueillir ! Voici les détails de votre réservation :</p>
            
            <div class="details">
                <h3>Détails de votre séjour :</h3>
                <p><strong>Nom complet :</strong> <?php echo htmlspecialchars($_SESSION['name']); ?></p>
                <p><strong>Check-in :</strong> <?php echo htmlspecialchars($_SESSION['dateA']); ?></p>
                <p><strong>Check-out :</strong> <?php echo htmlspecialchars($_SESSION['dateD']); ?></p>
                <p><strong>Nombre de personnes :</strong> <?php echo htmlspecialchars($_SESSION['np']); ?></p>
            </div>

            <h3>Informations supplémentaires :</h3>
            <p>Une confirmation a été envoyée à votre adresse e-mail. Si vous avez des questions, contactez-nous à <a href="mailto:
contact@chateaudenamur.cubilis-be.com">
contact@chateaudenamur.cubilis-be.com</a>.</p>
        </section>

        <a href="index.php" class="btn">Retour à l'accueil</a>
    </main>

    <footer>
        <p>Merci d'avoir choisi le Château de Namur. À bientôt !</p>
    </footer>
</body>
</html>
