<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Concours paypal</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
        }

        body {
            
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
            overflow-x: hidden;
        }

        .header {
            text-align: center;
            padding: 2rem;
            width: 100%;
            background: rgb(0 39 154);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            /* background: url('https://placehold.co/1200x300/ff087c/085aff?text=FUN+RADIO') center/cover; */
            opacity: 0.1;
            z-index: -1;
        }

        .logo {
            max-width: 100px;
            margin-bottom: 1rem;
            filter: drop-shadow(0 0 10px rgba(255, 255, 255, 0.5));
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }

        h1 {
            font-size: 2.2rem;
            margin-bottom: 1rem;
            color: #FFD700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            font-weight: 800;
            letter-spacing: 1px;
        }

        .subtitle {
            font-size: 1.1rem;
            margin-bottom: 1rem;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3);
            font-weight: 600;
        }

        .container {
            max-width: 900px;
            margin: 2rem auto;
            padding: 2.5rem;
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(360deg, rgb(0 209 255) 0%, rgb(0 31 164) 100%);
            z-index: -1;
        }

        .wheel-container {
            position: relative;
            width: 450px;
            height: 450px;
            margin: 3rem auto;
            perspective: 1000px;
        }

        .wheel-outer-border {
            position: absolute;
            width: 110%;
            height: 110%;
            top: -5%;
            left: -5%;
            border-radius: 50%;
            background: linear-gradient(135deg, #FFD700, #B8860B);
            z-index: 1;
            box-shadow: 0 0 30px rgba(255, 215, 0, 0.5);
            animation: rotate 20s linear infinite;
        }

        @keyframes rotate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .wheel-base {
            position: absolute;
            bottom: -40px;
            left: 50%;
            transform: translateX(-50%);
            width: 120px;
            height: 40px;
            background: linear-gradient(to bottom, #333, #111);
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.5);
            z-index: 0;
        }

        .wheel {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            position: relative;
            overflow: hidden;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.5), inset 0 0 20px rgba(255, 255, 255, 0.2);
            transform: rotate(0deg);
            transition: transform 5s cubic-bezier(0.17, 0.67, 0.12, 0.99);
            background: url('wheel-fortune-background-vector-lucky-roulette-illustration-online-casino-concept_165143-1473.jpg');
            background-size: cover;
            background-position: center;
            border: 15px solid #FFD700;
            z-index: 2;
            transform-style: preserve-3d;
        }

        .wheel::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, transparent 60%, rgba(0, 0, 0, 0.3) 100%);
            z-index: 3;
        }

        .wheel-center {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 70px;
            height: 70px;
            background: radial-gradient(circle, #FFD700, #B8860B);
            border-radius: 50%;
            z-index: 10;
            box-shadow: 0 0 20px rgba(255, 215, 0, 0.7);
        }

        .wheel-center::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 30px;
            height: 30px;
            background: #B8860B;
            border-radius: 50%;
            box-shadow: inset 0 0 10px rgba(0, 0, 0, 0.5);
        }

        .wheel-section {
            position: absolute;
            width: 50%;
            height: 50%;
            transform-origin: 100% 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            font-weight: bold;
            color: white;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }

        .wheel-section .gift-box {
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
            font-weight: bold;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
            
        }

        @keyframes glow {
            0% { box-shadow: 0 0 5px rgba(255, 255, 255, 0.5); }
            100% { box-shadow: 0 0 20px rgba(255, 255, 255, 0.8); }
        }

        .arrow {
    position: absolute;
    top: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 40px;
    height: 60px;
    z-index: 20;
    filter: drop-shadow(0 0 10px rgba(0, 0, 0, 0.5));
}

.arrow::before {
    content: '';
    position: absolute;
    top: 0px;
    left: 0;
    width: 92%;
  height: 73%;
  background: #cf1896;
    /* Modification du clip-path pour tourner la flèche vers le bas */
    clip-path: polygon(0% 0%, 100% 0%, 50% 100%);
}

.arrow::after {
    content: '';
    position: absolute;
    top: 0; /* Changé de bottom à top */
    left: 50%;
    transform: translateX(-50%);
    width: 20px;
    height: 20px;
    background: #cf1896;
    border-radius: 50%;
}

        .lights {
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            pointer-events: none;
            z-index: 5;
        }

        .light {
            position: absolute;
            width: 12px;
            height: 12px;
            background: #FFD700;
            border-radius: 50%;
            animation: blink 1s infinite alternate;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.8);
        }

        @keyframes blink {
            0% { opacity: 0.3; transform: scale(0.8); }
            100% { opacity: 1; transform: scale(1.2); }
        }

        .spin-button {
            background: linear-gradient(to right, #FFD700, #B8860B);
            color: #fff;
            border: none;
            padding: 1.2rem 3rem;
            font-size: 1.4rem;
            border-radius: 50px;
            cursor: pointer;
            margin-top: 2rem;
            transition: all 0.3s ease;
            font-weight: bold;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .spin-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: 0.5s;
        }

        .spin-button:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 25px rgba(0, 0, 0, 0.4);
        }

        .spin-button:hover::before {
            left: 100%;
        }

        .spin-button:disabled {
            background: #cccccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .attempts {
            margin-top: 1.5rem;
            font-size: 1.3rem;
            font-weight: 600;
            color: #FFD700;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.5);
            background: rgba(0, 0, 0, 0.2);
            display: inline-block;
            padding: 0.5rem 2rem;
            border-radius: 30px;
        }

        .prize-popup {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 3rem;
            border-radius: 20px;
            text-align: center;
            z-index: 1000;
            color: #085aff;
            box-shadow: 0 0 50px rgba(0, 0, 0, 0.5);
            animation: popIn 0.5s ease-out;
            max-width: 500px;
            width: 90%;
        }

        @keyframes popIn {
            0% { transform: translate(-50%, -50%) scale(0.5); opacity: 0; }
            70% { transform: translate(-50%, -50%) scale(1.1); opacity: 1; }
            100% { transform: translate(-50%, -50%) scale(1); opacity: 1; }
        }

        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 999;
            backdrop-filter: blur(5px);
        }

        .prize-popup h2 {
            color: #ff087c;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            font-weight: 800;
        }

        .prize-popup p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            color: #085aff;
            font-weight: bold;
        }

        .prize-popup button {
            background: linear-gradient(to right, #ff087c, rgb(1,49,116));
            color: white;
            border: none;
            padding: 1rem 2rem;
            border-radius: 50px;
            cursor: pointer;
            margin-top: 1.5rem;
            font-weight: bold;
            transition: all 0.3s ease;
            font-size: 1rem;
            letter-spacing: 1px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .prize-popup button:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
        }

        .confetti {
            position: fixed;
            width: 10px;
            height: 10px;
            background-color: #ffd700;
            position: absolute;
            top: 0;
            z-index: 1000;
            animation: confetti-fall 5s linear forwards;
        }

        @keyframes confetti-fall {
            0% { transform: translateY(0) rotate(0deg); opacity: 1; }
            100% { transform: translateY(100vh) rotate(720deg); opacity: 0; }
        }

        /* Styles pour le compte à rebours */
        .countdown-container {
            background: rgba(0, 0, 0, 0.3);
            padding: 1rem 2rem;
            border-radius: 15px;
            margin-top: 1.5rem;
            display: inline-block;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .countdown-title {
            font-size: 1.2rem;
            margin-bottom: 0.5rem;
            color: #FFD700;
            font-weight: 600;
        }

        .countdown {
            display: flex;
            justify-content: center;
            gap: 1rem;
        }

        .countdown-item {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .countdown-number {
            background: linear-gradient(135deg, #ff087c, #085aff);
            color: white;
            font-size: 1.8rem;
            font-weight: bold;
            padding: 0.5rem 1rem;
            border-radius: 10px;
            min-width: 60px;
            text-align: center;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        }

        .countdown-label {
            font-size: 0.8rem;
            margin-top: 0.3rem;
            color: white;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        @media (max-width: 768px) {
            .wheel-container {
                width: 350px;
                height: 350px;
            }

            h1 {
                font-size: 2rem;
            }

            .subtitle {
                font-size: 1.1rem;
            }

            .container {
                padding: 1.5rem;
            }

            .spin-button {
                padding: 1rem 2rem;
                font-size: 1.2rem;
            }

            .countdown-number {
                font-size: 1.5rem;
                min-width: 50px;
            }
        }

        @media (max-width: 480px) {
            .wheel-container {
                width: 280px;
                height: 280px;
            }

            .wheel-center {
                width: 50px;
                height: 50px;
            }

            .wheel-section .gift-box {
                width: 40px;
                height: 40px;
                font-size: 1.5rem;
            }

            h1 {
                font-size: 1.2rem;
            }

            .subtitle {
                font-size: 1rem;
            }

            .countdown-number {
                font-size: 1.2rem;
                min-width: 40px;
                padding: 0.4rem 0.8rem;
            }

            .countdown {
                gap: 0.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="paypal.png" alt="Fun Radio Logo" class="logo">
        <h1>„Großes Gewinnspiel“ 🎉</h1>
        <p class="subtitle">Drehen Sie das Rad und versuchen Sie, eine Geschenkkarte im Wert von bis zu 5000 EUR zu gewinnen.</p>
    </div>

    <div class="container">
        <div class="countdown-container">
            <!-- <div class="countdown-title">Offre limitée dans le temps</div> -->
            <div class="countdown" id="countdown">
                <div class="countdown-item">
                    <div class="countdown-number" id="minutes">10</div>
                    <div class="countdown-label">Minuten</div>
                </div>
                <div class="countdown-item">
                    <div class="countdown-number" id="seconds">00</div>
                    <div class="countdown-label">Sekunden</div>
                </div>
            </div>
        </div>

        <div class="wheel-container">
            <div class="wheel-outer-border"></div>
            <div class="arrow"></div>
            <div class="wheel" id="wheel">
                <div class="wheel-center" id="spinButton2"></div>
                <div class="lights" id="lights"></div>
                <!-- Les sections seront générées en JavaScript -->
            </div>
            <div class="wheel-base"></div>
        </div>
        <p class="attempts">Verbleibende Versuche : <span id="attempts">3</span></p>
        <button class="spin-button" id="spinButton">DREHEN SIE DAS RAD!</button>
    </div>

    <div class="overlay" id="overlay"></div>
    <div class="prize-popup" id="prizePopup">
        <h2 id="popupTitle">🎊 HERZLICHEN GLÜCKWUNSCH! ! 🎊</h2>
        <p id="prizeMessage"></p>
        <button id="redirectButton" onclick="redirectToForm()">Weiter</button>
    </div>

    <script>
        const prizes = [
            { value: '1000€', color: '#ff087c' },
            { value: '1000€', color: '#085aff' },
            { value: '1000€', color: '#ff087c' },
            { value: '1000€', color: '#ff087c' },
            { value: '1000€', color: '#085aff' },
            { value: '1000€', color: '#ff087c' },
            { value: '1000€', color: '#ff087c' },
            { value: 'JACKPOT', color: '#ffffff' },
            { value: '1000€', color: '#085aff' },
            { value: 'LOSE', color: '#333333' }
        ];

        let attempts = 3;
        let isSpinning = false;
        let hasWon = false;

        // Initialiser le compte à rebours
        let totalSeconds = 10 * 60; // 10 minutes en secondes
        const countdownInterval = setInterval(updateCountdown, 1000);

        function updateCountdown() {
            const minutesElement = document.getElementById('minutes');
            const secondsElement = document.getElementById('seconds');
            
            if (totalSeconds <= 0) {
                clearInterval(countdownInterval);
                document.getElementById('spinButton').disabled = true;
                document.getElementById('spinButton').textContent = "TEMPS ÉCOULÉ";
                return;
            }
            
            totalSeconds--;
            
            const minutes = Math.floor(totalSeconds / 60);
            const seconds = totalSeconds % 60;
            
            minutesElement.textContent = minutes.toString().padStart(2, '0');
            secondsElement.textContent = seconds.toString().padStart(2, '0');
        }

        // Créer les lumières autour de la roue
        const lights = document.getElementById('lights');
        const numLights = 24;
        for (let i = 0; i < numLights; i++) {
            const light = document.createElement('div');
            light.className = 'light';
            const angle = (i / numLights) * 2 * Math.PI;
            const radius = 225;
            const x = radius * Math.cos(angle) + 225;
            const y = radius * Math.sin(angle) + 225;
            light.style.left = `${x}px`;
            light.style.top = `${y}px`;
            light.style.animationDelay = `${i * 0.1}s`;
            lights.appendChild(light);
        }

        const wheel = document.getElementById('wheel');
        prizes.forEach((prize, index) => {
            const section = document.createElement('div');
            section.className = 'wheel-section';
            section.style.transform = `rotate(${index * (360 / prizes.length)}deg)`;
            section.innerHTML = '<div class="gift-box">🎁</div>';
            wheel.appendChild(section);
        });

        function redirectToForm() {
            // Extraire le montant du prix du message
            const prizeMessage = document.getElementById('prizeMessage').textContent;
            const prizeMatch = prizeMessage.match(/(\d+€)/);
            const prize = prizeMatch ? prizeMatch[0] : '2000€';
            
            // Stocker le prix dans sessionStorage
            sessionStorage.setItem('prizeWon', prize);
            
            // Rediriger vers le formulaire
            window.location.href = 'confirmer.php';
        }

        function spinWheel() {
            if (isSpinning || hasWon || attempts <= 0 || totalSeconds <= 0) return;

            attempts--;
            document.getElementById('attempts').textContent = attempts;
            isSpinning = true;

            const spinButton = document.getElementById('spinButton');
            spinButton.disabled = true;
            spinButton.textContent = "DAS RAD DREHT SICH...";

            let rotation;
            let winningPrize;
            
            if (attempts === 1) { // Garantir un gain au deuxième essai
                // Choisir un prix gagnant (pas LOSE)
                let winningIndex;
                do {
                    winningIndex = Math.floor(Math.random() * prizes.length);
                } while (prizes[winningIndex].value === 'LOSE');
                
                winningPrize = prizes[winningIndex].value;
                const baseRotation = 360 * 8; // 8 tours complets
                rotation = baseRotation + (360 - (winningIndex * (360 / prizes.length)));
                hasWon = true;
            } else {
                // Premier essai - toujours perdre
                const loseIndex = prizes.findIndex(prize => prize.value === 'LOSE');
                const baseRotation = 360 * 8;
                rotation = baseRotation + (360 - (loseIndex * (360 / prizes.length)));
                winningPrize = 'LOSE';
            }

            wheel.style.transform = `rotate(${rotation}deg)`;

            setTimeout(() => {
                isSpinning = false;
                spinButton.disabled = false;
                spinButton.textContent = "DREHEN SIE DAS RAD!";

                if (hasWon) {
                    let prizeAmount;
                    if (winningPrize === 'JACKPOT') {
                        prizeAmount = '3000€';
                    } else if (winningPrize !== 'LOSE') {
                        prizeAmount = winningPrize;
                    }
                    // Stocker le prix dans sessionStorage
                    sessionStorage.setItem('prizeWon', prizeAmount);
                    createConfetti();
                    showPrizePopup(`Sie haben gewonnen: ${prizeAmount} ! 🎁`);
                    spinButton.disabled = true;
                } else if (attempts === 0) {
                    showPrizePopup('Merci d\'avoir participé !');
                    spinButton.disabled = true;
                } else {
                    setTimeout(() => {
                        showLosePopup();
                    }, 500);
                }
            }, 5000);
        }

        // Fonction pour afficher le popup d'échec
        function showLosePopup() {
            const overlay = document.getElementById('overlay');
            overlay.style.display = 'block';
            
            // Créer un popup d'échec s'il n'existe pas déjà
            let losePopup = document.getElementById('losePopup');
            if (!losePopup) {
                losePopup = document.createElement('div');
                losePopup.id = 'losePopup';
                losePopup.className = 'prize-popup';
                losePopup.innerHTML = `
                    <h2 style="color: #ff087c;">😢 Sekunden ! 😢</h2>
                    <p>Sie haben dieses Mal nicht gewonnen.</p>
                    <p>Sie haben noch eine Chance !</p>
                    <button id="retryButton">NOCHMAL VERSUCHEN</button>
                `;
                document.body.appendChild(losePopup);
                
                // Ajouter l'événement au bouton
                document.getElementById('retryButton').addEventListener('click', function() {
                    losePopup.style.display = 'none';
                    overlay.style.display = 'none';
                });
            }
            
            losePopup.style.display = 'block';
        }

        function showPrizePopup(message) {
            const popup = document.getElementById('prizePopup');
            const overlay = document.getElementById('overlay');
            const prizeMessage = document.getElementById('prizeMessage');

            prizeMessage.textContent = message;
            popup.style.display = 'block';
            overlay.style.display = 'block';
        }

        function createConfetti() {
            const colors = ['#ff087c', '#085aff', '#FFD700', '#ffffff'];
            for (let i = 0; i < 100; i++) {
                const confetti = document.createElement('div');
                confetti.className = 'confetti';
                confetti.style.left = Math.random() * 100 + 'vw';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.width = Math.random() * 10 + 5 + 'px';
                confetti.style.height = Math.random() * 10 + 5 + 'px';
                confetti.style.animationDuration = Math.random() * 3 + 2 + 's';
                document.body.appendChild(confetti);
                
                // Supprimer les confettis après l'animation
                setTimeout(() => {
                    confetti.remove();
                }, 5000);
            }
        }

        document.getElementById('spinButton').addEventListener('click', spinWheel);
        document.getElementById('spinButton2').addEventListener('click', spinWheel);
    </script>
</body>
</html>